<?
/*
   MatDirLister 0.3 Script

   Created by Mattia Campolese; 23/05/2004 - 05/05/2007
   Email: webmaster@matsoftware.it
   URL: www.matsoftware.it
   Modified by Gianluca Greco - 07/07/2006
   Email: info@digitechonline.it
   URL: www.digitechonline.it
   -----------------------
   Please read the "Readme.txt" file
   before using this script
*/

$version = "0.3"; //script version
$data = "05/05/2007"; //last script modification
$dirw = WorkingDir();
$image_dir = $dirw."ico/Dir.gif"; //path of folder ico
$image_file = $dirw."ico/File.gif"; //path of file ico
$width_image = 20; //ico width
$image_default = 1; //it sets up if at the opening icons must be visualized or not
                    //1 = it visualizes icons
                    //0 = it does not visualizes icons

// Processing variables by "GET" input

$inpath = @$_GET['dir'];
$sub = @$_GET['sub'];
$listopt = @$_GET['listopt'];
$icons = @$_GET['icons'];

if (!IsSet($inpath) || ($inpath == "")) 
{
  $inpath = "";
  $directory = ".";
} 
 else $directory = explode("|",$inpath); 

if (!IsSet($sub) || ($sub < 0)) 
{
  $sub = 0;
  $directory = ".";
}

session_start();

if (!isset($_SESSION['image_default']))
{
  if ($image_default == 1)
  {
    session_register("image_default");
    $_SESSION['image_default'] = 1;
  }
}

if ($_SESSION['image_default'] == 1)
{
  $icons = "1";
  $_GET['icons'] = "1";
}
############### Function ##########################################

function WorkingDir()
{
  #funzione che restituisce la directory di lavoro ossia la directory
  #dove  presente lo script in esecuzione
  $i = 0;
  $dir = "";
  $text = explode("/", $_SERVER["PHP_SELF"]);
  $cont = count($text);

  foreach ($text as $key=>$value)
  {
    if ($i != ($cont - 1))
    {
    $dir .= $value."/";
    }
    $i++;
  }
    
  return $dir;
}

function ListDirFile($file_array="",$inpath="",$sub=0,$listopt="",$ico="1")
{
  global $image_dir;
  global $image_file;
  global $width_image;
  
  if (!is_array($file_array))
  {
    return 0;
  }
  
  $list = array();
  
  foreach ($file_array as $file) {
  
  if (($file == ".") || ($file == "..") ) continue;

  // Checking if it is a directory or a file
  
  $list[] = "";
  
  if ((FileType($file) == "dir"))
    {
      if ($inpath != "")
      {
        $path = $inpath . $file . "|";
        $subw = @$sub + 1;
      } 
      else
      {  
        $path = $file ."|";
        $subw = 1;
      }
       
      if ($ico == "1")
      {
        if (file_exists($_SERVER['DOCUMENT_ROOT'].$image_dir))
        {
          $list[] .= "<img src=\"".$image_dir."\" width=\"".$width_image."\" alt=\"File\" >";
        }
      }
        
     $list[] .= "<a class=\"dir\" href=\"dirlist.php?dir=".$path."&amp;sub=".$subw."&amp;listopt=".$listopt."&amp;icons=".$ico."\">".$file."</a><br>\n";
    }
  }
  
  foreach ($file_array as $file) {
  
  if (($file == ".") || ($file == "..") ) continue;
  
  // Checking if it is a directory or a file
  
  if ((FileType($file) != "dir"))
    {
      if ($inpath != "")
      {
        $path = str_replace("|","/",$inpath) . $file; 
      }
      else
      {
        $path = $file;
      }
      
      if ($ico == "1")
      {
        if (file_exists($_SERVER['DOCUMENT_ROOT'].$image_file))
        {
          $list[] .= "<img src=\"".$image_file."\" width=\"".$width_image."\" alt=\"File\" >";
        }
      }
    
      $list[] .= "<a class=\"file\" href=\"".$path."\" target=\"_new\">".$file."</a><br>\n";
    }
  }
  
  return $list;
}

function AlphList($file_array="",$inpath="",$sub=0,$listopt="",$ico="1")
{
  global $image_dir;
  global $image_file;
  global $width_image;
  
  if (!is_array($file_array))
  {
    return 0;
  }
  
  $list = array();
  
  foreach ($file_array as $file) {
  
  if (($file == ".") || ($file == "..") ) continue;
  
  // Checking if it is a directory or a file
  
  $list[] = "";
  
  if ((FileType($file) == "dir"))
    {
      if ($inpath != "")
       {
        $path = $inpath . $file . "|";
        $subw = @$sub + 1;
       } 
        else
       {  
        $path = $file ."|";
        $subw = 1;
       }
       
      if ($ico == "1")
      {
        if (file_exists($_SERVER['DOCUMENT_ROOT'].$image_dir))
        {
          $list[] .= "<img src=\"".$image_dir."\" width=\"".$width_image."\" alt=\"Dir\" >";
        }
      }
      $list[] .= "<a class=\"dir\" href=\"dirlist.php?dir=".$path."&amp;sub=".$subw."&amp;listopt=".$listopt."&amp;icons=".$ico."\">".$file."</a><br>\n";
    }
    else 
    { 
      if ($inpath != "") 
      {
        $path = str_replace("|","/",$inpath) . $file;
      }
      else
      {
        $path = $file;
      }
      
      if ($ico == "1")
      {
        if (file_exists($_SERVER['DOCUMENT_ROOT'].$image_file))
        {
          $list[] .= "<img src=\"".$image_file."\" width=\"".$width_image."\" alt=\"Dir\" >";
        }
      }
      $list[] .= "<a class=\"file\" href=\"".$path."\" target=\"_new\">".$file."</a><br>\n";  
    }
  }
  
  return $list;
}

###################################################################

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN""http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<title>MatDirLister 0.3</title>
<style type="text/css">
.navigate
{
	font-family : Verdana, Geneva, Arial, Helvetica, sans-serif;
	font-weight : normal;
	font-size : 10px;
	color: blue;	
}
.title
{
	font-family : Verdana, Geneva, Arial, Helvetica, sans-serif;
	font-weight : bold;
	font-size : 14px;
	color: black;	
}
.dir
{
  	font-family : Verdana, Geneva, Arial, Helvetica, sans-serif;
	font-weight : bold;
	font-size : 12px;
	color: navy;	

}
.file
{
  	font-family : Verdana, Geneva, Arial, Helvetica, sans-serif;
	font-weight : normal;
	font-size : 12px;
	color: blue;	
}
.copy
{
	font-family : Verdana, Geneva, Arial, Helvetica, sans-serif;
	font-weight : normal;
	font-size : 10px;
	color: black;	
}
.select
{
  font-family : Verdana, Geneva, Arial, Helvetica, sans-serif;
	font-weight : normal;
	font-size : 10px;
	color: blue;
}

</style>
<body>
<!-- Created with MatDirLister 0.3 - www.matsoftware.it -->
<div class="title">
List option:
</div>
<div class="select">
<form method="get" action="./dirlist.php">
<?php
if ($inpath != "")
{
  echo ("<input type=\"hidden\" name=\"dir\" value=\"".$inpath."\">\n");
}
if ($sub != 0)
{
  echo ("<input type=\"hidden\" name=\"sub\" value=\"".$sub."\">\n");
}
echo ("Dir/File order &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
<input type=\"radio\" name=\"listopt\" value=\"dirfile\"");
if (!isset($_GET['listopt']))
{
 echo (" checked=\"checked\"");
 $list = 1;
 $listopt = "dirfile";
}
else
{
  if ($_GET['listopt'] == "dirfile")
  {
   echo (" checked=\"checked\"");
   $list = 1;
  }
}
echo (" onclick=\"submit()\"><br>\n");

echo ("Alphabetical order <input type=\"radio\" name=\"listopt\" value=\"alph\"");
if (isset($_GET['listopt']))
{
  if ($_GET['listopt'] == "alph")
  {
   echo (" checked=\"checked\"");
   $list = 2;
  }
}
echo (" onclick=\"submit()\"><br><br>\n");

echo ("Images ON/OFF &nbsp&nbsp&nbsp<input type=\"checkbox\" name=\"icons\" value=\"1\"");
if (@$_GET['icons'] == "1")
{
  echo (" checked=\"checked\"");
}
echo (" onclick=\"submit()\">\n");
?>
</form>
</div>

<br>

<div class="title">
List Directory & File:
</div>
<a class="navigate" href="dirlist.php?listopt=<?php print $listopt; ?>&amp;icons=<?php print $icons; ?>">Home</a>
<?

// Processing directories

$path = "";
for ($i=0; $i<=$sub; $i++)
 { 
 $folder = @chdir($directory[$i]); 
 $path = $path . $directory[$i] . "|";
  if (($directory[$i] != "") and ($directory[$i] != "."))
   echo " - <a class=\"navigate\" href=\"dirlist.php?dir=". $path . "&amp;sub=".($i+1)."&amp;listopt=".$listopt."&amp;icons=".$icons."\">" . $directory[$i] . "</a>";
 } 

echo "\n<hr>\n";

// Getting directory's info...
  
$folder = opendir(".");

while ($file = ReadDir($folder))
 {
  $file_array[] = $file;
 }

#asort($file_array);

// Processing Files&Directories list element by element

if (@$list == 1)
{
  $array = ListDirFile($file_array,$inpath,$sub,$listopt,$icons);
}
elseif (@$list == 2)
{
  $array = AlphList($file_array,$inpath,$sub,$listopt,$icons);
}
else
{
  $array = "";
}

if (is_array($array))
{
  foreach ($array as $k=>$v)
  {
    echo ($v);
  }
}

// Unsetting all variables
unset($file_array);
unset($file);
unset($folder);
unset($directory);
unset($sub);
unset($subw);
unset($path);

$_SESSION['image_default'] = 0;
?>
<hr>
<div class="copy" align="center">
Page created with <b>MatDirLister <?php print $version." - ".$data; ?></b> by Mattia Campolese,
<a href="http://www.matsoftware.it">www.matsoftware.it</a> - webmaster @ matsoftware.it. <br> 
Modified by Gianluca Greco (<a href="http://www.digitechonline.it">www.digitechonline.it</a>)
</div>
</body>
</html>
